import { setTemp } from "../type/element/setTemp.js"

export function suspendIframes(options) {
  const suspendeds = new Set()
  let timeoutId

  for (const iframe of document.querySelectorAll("iframe")) {
    suspendeds.add(setTemp(iframe, { class: { "action-false": true } }))
  }

  function restoreIframes() {
    clearTimeout(timeoutId)
    for (const restore of suspendeds) restore()
    suspendeds.clear()
  }

  if (options?.timeout) {
    timeoutId = setTimeout(restoreIframes, options.timeout)
  }

  return restoreIframes
}
