export async function updateCache(path, options) {
  if (!navigator.onLine && options?.force !== true) return
  if (await caches.match(path)) {
    return caches.keys().then((keys) =>
      Promise.all(
        keys.map(async (key) => {
          const cache = await caches.open(key)
          if (await cache.match(path)) {
            await cache.delete(path)
            if (options?.delete !== true) await cache.add(path)
          }
        }),
      ),
    )
  }
}
