import { Mp3Encoder } from "../../../../formats/codec/lame.js"

const MAX_AMPLITUDE = 0x7f_ff
const BLOCK_SIZE = 1152 // can be anything but make it a multiple of 576 to make encoders life easier

export function setup({ port, sampleRate, kbps }) {
  const mp3encoder = new Mp3Encoder(2, sampleRate || 44_100, kbps || 123)

  const mp3Data = []
  let blockIndex = 0

  function encodeChunk(buffers) {
    const chunkL = buffers[0].subarray(blockIndex, blockIndex + BLOCK_SIZE)
    const chunkR = buffers[1].subarray(blockIndex, blockIndex + BLOCK_SIZE)
    const mp3buf = mp3encoder.encodeBuffer(chunkL, chunkR)

    if (mp3buf.length > 0) {
      mp3Data.push(mp3buf)
    }

    blockIndex += BLOCK_SIZE
  }

  port.onmessage = ({ data: channels }) => {
    const buffers = []

    for (let channel = 0, l = channels.length; channel < l; channel++) {
      const buffer = channels[channel]
      const samples = new Int16Array(128)

      for (let i = 0; i < 128; ++i) {
        let sample = buffer[i]

        // clamp and convert to 16bit number
        sample = Math.min(1, Math.max(-1, sample))
        sample = Math.round(sample * MAX_AMPLITUDE)

        samples[i] = sample
      }

      buffers.push(samples)
    }

    console.log(buffers)

    encodeChunk(buffers)
  }
}

/*  */
/*  */
/*  */
/*  */

// @src https://github.com/zhuker/lamejs/blob/master/worker-example/worker-realtime.js

// import { Mp3Encoder } from "../../../../formats/codec/lame.js"

// const maxSamples = 1152
// let mp3Encoder
// let samplesMono
// let config
// let dataBuffer

// function clearBuffer() {
//   dataBuffer = []
// }

// function appendToBuffer(mp3Buf) {
//   dataBuffer.push(new Int8Array(mp3Buf))
// }

// function init(prefConfig) {
//   config = prefConfig || { debug: true }
//   mp3Encoder = new Mp3Encoder(
//     1,
//     config.sampleRate || 44_100,
//     config.bitRate || 123
//   )
//   clearBuffer()
// }

// function floatTo16BitPCM(input, output) {
//   for (let i = 0; i < input.length; i++) {
//     const s = Math.max(-1, Math.min(1, input[i]))
//     output[i] = s < 0 ? s * 0x80_00 : s * 0x7f_ff
//   }
// }

// function convertBuffer(arrayBuffer) {
//   const data = new Float32Array(arrayBuffer)
//   const out = new Int16Array(arrayBuffer.length)
//   floatTo16BitPCM(data, out)
//   return out
// }

// function encode(arrayBuffer) {
//   samplesMono = convertBuffer(arrayBuffer)
//   let remaining = samplesMono.length
//   for (let i = 0; remaining >= 0; i += maxSamples) {
//     const left = samplesMono.subarray(i, i + maxSamples)
//     const mp3buf = mp3Encoder.encodeBuffer(left)
//     appendToBuffer(mp3buf)
//     remaining -= maxSamples
//   }
// }

// function finish() {
//   appendToBuffer(mp3Encoder.flush())
//   self.postMessage({
//     cmd: "end",
//     buf: dataBuffer,
//   })
//   if (config.debug) {
//     console.log("Sending finished command")
//   }

//   clearBuffer() // free up memory
// }

// self.onmessage = function (e) {
//   switch (e.data.cmd) {
//     case "init":
//       init(e.data.config)
//       break

//     case "encode":
//       encode(e.data.buf)
//       break

//     case "finish":
//       finish()
//       break

//     default:
//   }
// }
